library(memisc)
library(mestats)
load("mclogit-classd-churchat.RData")

myGetSummary.classd.churchat.time <- function(x)getSummary.mclogit(x,rearrange=list(
        "Econ. L/R"=c(
                    "Squared effect"="I(econdim^2)",
                    "Linear effect"="econdim",
                    " x Intermediate/Manual worker"="econdim:classdIntermediate",
                    " x Service class/Manual worker"="econdim:classdService class",
                    " x Self-employed/Manual worker"="econdim:classdSelf-employed",
                    " x Occasional churchgoer/Non-churchgoer"= "econdim:churchatFew times a year",
                    " x Weekly churchgoer/Non-churchgoer"="econdim:churchatOnce a week or more",
                    " x Time"="econdim:Time",
                    " x Intermediate/Manual worker x Time"="econdim:classdIntermediate:Time",
                    " x Service class/Manual worker x Time"="econdim:classdService class:Time",
                    " x Self-employed/Manual worker x Time"="econdim:classdSelf-employed:Time",
                    " x Occasional churchgoer/Non-churchgoer x Time"= "econdim:churchatFew times a year:Time",
                    " x Weekly churchgoer/Non-churchgoer x Time"="econdim:churchatOnce a week or more:Time"
                    ),
        "Lib./auth."=c(
                    "Squared effect"="I(authlib^2)",
                    "Linear effect"="authlib",
                    " x Intermediate/Manual worker"="classdIntermediate:authlib",
                    " x Service class/Manual worker"="classdService class:authlib",
                    " x Self-employed/Manual worker"="classdSelf-employed:authlib",
                    " x Occasional churchgoer/Non-churchgoer"= "churchatFew times a year:authlib",
                    " x Weekly churchgoer/Non-churchgoer"="churchatOnce a week or more:authlib",
                    " x Time"="Time:authlib",
                    " x Intermediate/Manual worker x Time"="classdIntermediate:Time:authlib",
                    " x Service class/Manual worker x Time"="classdService class:Time:authlib",
                    " x Self-employed/Manual worker x Time"="classdSelf-employed:Time:authlib",
                    " x Occasional churchgoer/Non-churchgoer x Time"= "churchatFew times a year:Time:authlib",
                    " x Weekly churchgoer/Non-churchgoer x Time"="churchatOnce a week or more:Time:authlib"
                    ),
        "Mod./trad."=c(
                    "Squared effect"="I(tradmod^2)",
                    "Linear effect"="tradmod",
                    " x Intermediate/Manual worker"="classdIntermediate:tradmod",
                    " x Service class/Manual worker"="classdService class:tradmod",
                    " x Self-employed/Manual worker"="classdSelf-employed:tradmod",
                    " x Occasional churchgoer/Non-churchgoer"= "churchatFew times a year:tradmod",
                    " x Weekly churchgoer/Non-churchgoer"="churchatOnce a week or more:tradmod",
                    " x Time"="Time:tradmod",
                    " x Intermediate/Manual worker x Time"="classdIntermediate:Time:tradmod",
                    " x Service class/Manual worker x Time"="classdService class:Time:tradmod",
                    " x Self-employed/Manual worker x Time"="classdSelf-employed:Time:tradmod",
                    " x Occasional churchgoer/Non-churchgoer x Time"= "churchatFew times a year:Time:tradmod",
                    " x Weekly churchgoer/Non-churchgoer x Time"="churchatOnce a week or more:Time:tradmod"
                    )
        ))



(mtable.mclogit.classd.churchat <- mtable(mclogit.classd.churchat,
                      digits=2,
                      summary.stats=c("Dispersion","Deviance","N"),
                      getSummary=myGetSummary.classd.churchat.time))


writeLines(
  toLatex(mtable.mclogit.classd.churchat,ddigits=-1),
  con="Table2.tex"
  )
